 
Option Explicit

Const sDefaultDir = "C:\"
Const sDefaultFilename = "overwrite.garbage"
Const lStartBlockSize = 32768

Call Main

Sub Main()
  Dim sPath, sFilename
  Dim oArgs, oFS, oDrive, oRegExp, oMatches

  ShowStartMsg

  Set oArgs = WScript.Arguments
  Set oFS = CreateObject("Scripting.FileSystemObject")

  If oArgs.Count = 1 Then
    If oArgs(0) = "/?" Then
      ShowHelp true
    End If
  End If

  If oArgs.Count > 2 Then
    ShowMsg "ERROR: Invalid command line parameters (too many parameters specified)", true, true
  End If

  If oArgs.Count > 0 Then
    sPath = oFS.GetAbsolutePathName(oArgs(0))
  Else
    sPath = ""
  End If

  If oFS.FolderExists(sPath) Then
    WScript.Echo "Checking folder " & Chr(34) & sPath & Chr(34) & ": OK"
    If Right(sPath, 1) <> "\" Then
      sPath = sPath & "\"
    End If
  Else
    WScript.Echo "Checking folder " & Chr(34) & sPath & Chr(34) & ": FAILED"
    sPath = sDefaultDir
    WScript.Echo "INFO: Using default folder " & Chr(34) & sPath & Chr(34)
  End If

  If oArgs.Count = 2 Then
    sFilename = oArgs(1)
    If sFilename = "" Then
      ShowMsg "ERROR: Filename must not be empty", true, true
    End If
  Else
    sFilename = sDefaultFilename
    WScript.Echo "INFO: Using default filename " & Chr(34) & sFilename & Chr(34)
  End If

  Set oRegExp = new RegExp
  oRegExp.Pattern = "[\\\/\:\*\?\" & Chr(34) & "\<\>\|]"
  Set oMatches = oRegExp.Execute(sFilename)
  If oMatches.Count = 0 Then
    WScript.Echo "Validating filename: OK"
  Else
    WScript.Echo "Validating filename: FAILED"
    ShowMsg "ERROR: Filename must not contain the following characters:"_
      & " \ / : * ? " & Chr(34) & " < > |", true, true
  End If

  If oFS.FileExists(sPath & sFilename) = False Then
    WScript.Echo "Ensuring that file " & Chr(34) & sFilename & Chr(34) &_
      " does not exist: OK"
  Else
    WScript.Echo "Ensuring that file " & Chr(34) & sFilename & Chr(34) &_
      " does not exist: FAILED"
    ShowMsg "ERROR: File " & Chr(34) & sPath & sFilename & Chr(34) & " already exists", true, true    
  End If

  Set oDrive = oFS.GetDrive(oFS.GetDriveName(sPath))
  If UCase(oDrive.FileSystem) = "NTFS" Then
    WScript.Echo "Checking for NTFS: OK"  
  Else
    WScript.Echo "Checking for NTFS: FAILED"
    ShowMsg "ERROR: " & oDrive.FileSystem & " file system not supported", true, true
  End If

  Select Case oDrive.DriveType
    Case 1, 2
      WScript.Echo "Checking drive type: OK"
    Case Else
      WScript.Echo "Checking drive type: FAILED"
      Select Case oDrive.DriveType
        Case 3
          ShowMsg "ERROR: Network drives are not supported", true, true
        Case 4
          ShowMsg "ERROR: CD-ROM drives are not supported", true, true
        Case 5
          ShowMsg "ERROR: RAM Disk drives are not supported", true, true
        Case Else
          ShowMsg "ERROR: Unkown drives are not supported", true, true
      End Select
  End Select

  If oDrive.FreeSpace > 0 Then
    WScript.Echo "Checking for free space: OK"
  Else
    WScript.Echo "Checking for free space: FAILED"
    WScript.Echo "INFO: No free space available (no action required)"
    ShowMsg "INFO: Exiting Overwrite Script...", false, true    
  End If

  WScript.Echo "Creating garbage file " & Chr(34) & sPath & sFilename & Chr(34) & "..."
  CreateGarbageFile sPath & sFilename, oFS
  WScript.Echo "Garbage file successfully created!"
  WScript.Echo "INFO: " & oDrive.AvailableSpace & " byte(s) remained which could not be overwritten"
  WScript.Echo "Deleting garbage file..."
  oFS.DeleteFile sPath & sFilename
  WScript.Echo "Garbage file successfully deleted!"
  WScript.Echo "Exiting Overwrite Script..."
  WScript.Quit
End Sub

Sub CreateGarbageFile(sAbsFilename, oFS)
  Dim bSngByteBlock
  Dim sBlock
  Dim oFile, oDrive

  bSngByteBlock = false
  Set oDrive = oFS.GetDrive(oFS.GetDriveName(sAbsFilename))
  Set oFile = oFS.CreateTextFile(sAbsFilename, false, false)

  sBlock = GenGarbageBlock(lStartBlockSize, true)
  On Error Resume Next

  Do While oDrive.FreeSpace > 0
    If oDrive.FreeSpace < lStartBlockSize Then
      If bSngByteBlock = false Then
        WScript.Echo "INFO: Falling back to single byte block"
        bSngByteBlock = true
      End If
      sBlock = GenGarbageBlock(1, false)
    End If
    oFile.Write sBlock
    If Err.Number <> 0 Then
      WScript.Echo "WARNING: Error " & Chr(34) & Err.Description & Chr(34) & " ("_
        & Err.Number & ") occured while writing garbage file"
      Exit Do
    End If
  Loop

  On Error GoTo 0
  oFile.Close
End Sub

Function GenGarbageBlock(lSize, bShowMsg)
  Dim lCounter

  If bShowMsg = True Then
    WScript.Echo "Creating new random data block (" & lSize & " bytes)..."
  End If

  GenGarbageBlock = ""
  Randomize
  For lCounter = 1 To lSize
    GenGarbageBlock = GenGarbageBlock & Chr(Int ((255 + 1) * Rnd))
  Next

  If bShowMsg = True Then
    WScript.Echo "Data block complete"
    WScript.Echo "Continue writing garbage file..."
  End If
End Function

Sub ShowStartMsg()
  WScript.Echo "Overwrite Script 1.0 (2004-09-05)"
  WScript.Echo "Copyright (C) 2004 Dennis Dietrich"
  WScript.Echo "http://www.myblog.de/scotty"
  WScript.Echo ""
  WScript.Echo "WARNING: The script is experimental. Use it at your own risk!"
  WScript.Echo "To cancel the execution of this script press CTRL + C"
  WScript.Echo ""
End Sub

Sub ShowMsg(sMsg, bShowHelpHint, bExit)
  WScript.Echo sMsg
  If bShowHelpHint = True Then
    WScript.Echo ""
    WScript.Echo "Use " & Chr(34) & "CScript Overwrite.vbs /?" & Chr(34) & " to get help."
  End If
  If bExit = True Then
    WScript.Quit
  End If
End Sub

Sub ShowHelp(bExit)
  WScript.Echo "Cleans free disk space from recoverable data by overwriting it with random"
  WScript.Echo "information. For a higher level of security execute this script at least three"
  WScript.Echo "times. Only NTFS partitions are supported."
  WScript.Echo ""
  WScript.Echo "CScript Overwrite.vbs [path] [filename]"
  If bExit = True Then
    WScript.Quit
  End IF
End Sub